const path = require('path');

module.exports = {
  // Daily limit to avoid bans
  DAILY_LIMIT: 300,
  
  // Delays in milliseconds
  MIN_DELAY: 15000, // 15 seconds
  MAX_DELAY: 45000, // 45 seconds
  
  // File paths
  USERS_FILE: path.join(__dirname, 'users.txt'),
  PROCESSED_FILE: path.join(__dirname, 'processed.txt'),
  
  // Puppeteer settings
  USER_DATA_DIR: path.join(__dirname, 'user_data'),
  HEADLESS: false, // Must be false to see the browser and login
};
