/**
 * License Activation for CLI Version
 * Platform-specific pricing: Windows $7.99, Mac $9.99
 */

const licenseManager = require('./license_manager');
const readline = require('readline');
const os = require('os');

// Platform detection
const platform = os.platform();
const platformName = platform === 'darwin' ? 'Mac' : platform === 'win32' ? 'Windows' : 'Linux';
const platformPrice = platform === 'darwin' ? '$9.99' : '$7.99';

async function activateLicense() {
  const rl = readline.createInterface({
    input: process.stdin,
    output: process.stdout
  });

  return new Promise((resolve) => {
    console.log('\n╔═══════════════════════════════════════════════════════════╗');
    console.log('║   🔑 ACTIVATE UNJANKYIG PREMIUM                          ║');
    console.log('╚═══════════════════════════════════════════════════════════╝\n');
    console.log(`   Platform: ${platformName}`);
    console.log(`   Price: ${platformPrice}\n`);
    
    rl.question('Enter your license key: ', (key) => {
      rl.close();
      
      // Validate with your server
      const result = validateLicenseKey(key);
      
      if (result.valid) {
        // Save premium status
        const license = {
          isPremium: true,
          purchaseDate: new Date().toISOString(),
          email: result.email,
          licenseKey: key
        };
        
        // This saves to the same file premium app uses
        const fs = require('fs');
        const path = require('path');
        const os = require('os');
        const licenseFile = path.join(os.homedir(), '.unjankyourinstagram', 'license.json');
        
        if (!fs.existsSync(path.dirname(licenseFile))) {
          fs.mkdirSync(path.dirname(licenseFile), { recursive: true });
        }
        
        fs.writeFileSync(licenseFile, JSON.stringify(license, null, 2));
        
        console.log('\n✅ SUCCESS! Premium activated!');
        console.log('   You now have UNLIMITED unfollows!');
        console.log('   Thank you for supporting UnjankyIG! 🙏\n');
        
        resolve(true);
      } else {
        console.log('\n❌ Invalid license key.');
        console.log('   Please check your email or contact support.\n');
        resolve(false);
      }
    });
  });
}

function validateLicenseKey(key) {
  // Option 1: Check with your server (recommended)
  // const response = fetch('https://yourapi.com/validate', { ... })
  
  // Option 2: Simple local validation (for testing)
  // Format: UNJANKY-XXXX-XXXX-XXXX-XXXX
  const pattern = /^UNJANKY-[A-Z0-9]{4}-[A-Z0-9]{4}-[A-Z0-9]{4}-[A-Z0-9]{4}$/;
  
  if (pattern.test(key.toUpperCase())) {
    return {
      valid: true,
      email: 'customer@example.com'
    };
  }
  
  return { valid: false };
}

module.exports = { activateLicense };

