@echo off
title UnjankyIG - First Time Setup
color 0A

echo.
echo ================================================
echo    UnjankyIG - Automatic Setup
echo ================================================
echo.
echo This will set up everything automatically!
echo Just wait a moment...
echo.

REM Check if Node.js is installed
where node >nul 2>nul
if %ERRORLEVEL% NEQ 0 (
    echo ❌ ERROR: Node.js is not installed!
    echo.
    echo Please install Node.js first:
    echo 1. Go to: https://nodejs.org
    echo 2. Download the "LTS" version
    echo 3. Install it
    echo 4. Run this file again
    echo.
    pause
    start https://nodejs.org
    exit /b 1
)

echo ✅ Node.js found!
echo.
echo 📦 Installing dependencies (this takes 1-2 minutes)...
echo Please wait...
echo.

REM Install dependencies
call npm install

if %ERRORLEVEL% EQU 0 (
    echo.
    echo ================================================
    echo    ✅ SETUP COMPLETE!
    echo ================================================
    echo.
    echo Everything is ready to go!
    echo.
    echo Press any key to launch UnjankyIG Dashboard...
    pause >nul
    
    REM Delete this setup file so it doesn't run again
    del "%~f0"
    
    REM Launch dashboard
    start "" "Start_Dashboard.bat"
) else (
    echo.
    echo ❌ Installation failed!
    echo.
    echo Please try running this command manually:
    echo npm install
    echo.
    pause
)

